/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import panther.util.general.ProcessBufferingThread;
import panther.util.unicon.ThreadUtil;

public class BufferedProcess {
    protected Process process;
    protected StringBuilder standardOutput = new StringBuilder();
    protected int standardOutputMark = 0;
    protected ProcessBufferingThread standardOutputThread;
    protected StringBuilder standardError = new StringBuilder();
    protected int standardErrorMark = 0;
    protected ProcessBufferingThread standardErrorThread;

    public BufferedProcess(Process process, boolean bl) throws Exception {
        this.process = process;
        this.openThreads(bl);
    }

    public void close() {
        if (this.standardOutputThread != null) {
            this.standardOutputThread.beDone();
            this.standardOutputThread = null;
        }
        if (this.standardErrorThread != null) {
            this.standardErrorThread.beDone();
            this.standardErrorThread = null;
        }
    }

    public void destroy() {
        this.process.destroy();
        this.close();
    }

    public int exitValue() throws IllegalThreadStateException {
        return this.process.exitValue();
    }

    public String getStandardOutput() {
        this.standardOutputMark = this.standardOutput.length();
        return this.standardOutput.substring(0, this.standardOutputMark);
    }

    public String getStandardOutputSinceLastMark() {
        int n = this.standardOutput.length();
        String string = this.standardOutput.substring(this.standardOutputMark, n);
        this.standardOutputMark = n;
        return string;
    }

    public String getStandardError() {
        this.standardErrorMark = this.standardError.length();
        return this.standardError.substring(0, this.standardErrorMark);
    }

    public String getStandardErrorSinceLastMark() {
        int n = this.standardError.length();
        String string = this.standardError.substring(this.standardErrorMark, n);
        this.standardErrorMark = n;
        return string;
    }

    public boolean hasStandardError() {
        return this.standardError.length() > 0;
    }

    public boolean hasStandardOutput() {
        return this.standardOutput.length() > 0;
    }

    public int waitFor() throws InterruptedException {
        int n = this.process.waitFor();
        while (!this.standardOutputThread.isReadDone() || !this.standardErrorThread.isReadDone()) {
            ThreadUtil.guaranteedSleep(100L);
        }
        this.standardOutputThread = null;
        this.standardErrorThread = null;
        return n;
    }

    protected void openThreads(boolean bl) throws Exception {
        this.standardOutputThread = new ProcessBufferingThread(this.process.getInputStream(), this.standardOutput);
        this.standardOutputThread.setDaemon(true);
        this.standardOutputThread.start();
        if (!bl) {
            this.standardErrorThread = new ProcessBufferingThread(this.process.getErrorStream(), this.standardError);
            this.standardErrorThread.setDaemon(true);
            this.standardErrorThread.start();
        }
    }
}

